Attribute VB_Name = "Module1"
Global Const PICDEFFILE$ = "PictureDefs.Dat"
Global Const SPRITEDEFFILE$ = "Sprites.Dat"
Global Const CurrVers$ = "ION FORMAT VERSION: 1.0"
Type Spfs
  FrameName As String
  picname As String
  Duration As Integer
End Type
Type SpfGs
  GroupRepeats As Boolean
  SpriteGroupName As String
  SpriteFrames(100) As Spfs
  FrameMax As Integer
End Type
Type Sps
  SpriteName As String
  SpriteFrameGroups(20) As SpfGs
  GroupMax As Integer
End Type
Global Sprites(200) As Sps
Type pcz
  Masked As Boolean
  GraphicsLib As String
  picname As String
  X As Integer
  Y As Integer
  Width As Integer
  Height As Integer
End Type
Global Picz(500) As pcz
Global PicMax As Integer
Global SpriteMax As Integer
Type Lbs
  LibName As String
  picname As String
End Type
Global GraphicLibs(100) As Lbs
Global LibMax As Integer
Sub LoadPicInfo()
On Error GoTo ERR1
PicMax = 0
Open PICDEFFILE$ For Input As #1
  Line Input #1, a$
  If a$ <> CurrVers$ Then
    Call CurrVersError
  End If
  Do
    Line Input #1, a$
    If a$ = "[ENDOFFILE]" Then Exit Do
    If a$ = "[PICDEF]" Then
      'increments the current picture num
      PicMax = PicMax + 1
      
      'Picture name
      Line Input #1, a$
      fval$ = GetPropertyValue(a$)
      Picz(PicMax).picname = fval$
      
      'Graphics Library of the pic
      Line Input #1, a$
      fval$ = GetPropertyValue(a$)
      Picz(PicMax).GraphicsLib = fval$
      
      
      'X
      Line Input #1, a$
      fval$ = GetPropertyValue(a$)
      Picz(PicMax).X = Val(fval$)
      
      'Y
      Line Input #1, a$
      fval$ = GetPropertyValue(a$)
      Picz(PicMax).Y = Val(fval$)
      
      'Width
      Line Input #1, a$
      fval$ = GetPropertyValue(a$)
      Picz(PicMax).Width = Val(fval$)
      
      'Height
      Line Input #1, a$
      fval$ = GetPropertyValue(a$)
      Picz(PicMax).Height = Val(fval$)
    
    End If
  Loop
Close #1
Exit Sub
ERR1:
Close #1
PicMax = 0
End Sub
Sub CurrVersError()
MsgBox "Wrong file version"
End
End Sub
Public Function GetPropertyValue(TextString) As String
GetPropertyValue = Right$(TextString, Len(TextString) - InStr(1, TextString, " "))
If InStr(1, TextString, " ") = 0 Then GetPropertyValue = ""
End Function

Sub LoadAll()
Call LoadPicInfo
Call LoadSpriteInfo
End Sub
Sub LoadSpriteInfo()
On Error GoTo ERR2
SpriteMax = 0
Open SPRITEDEFFILE$ For Input As #1
  Line Input #1, a$
  If a$ <> CurrVers$ Then
    Call CurrVersError
  End If
  Do
    Line Input #1, a$
    If a$ = "[ENDOFFILE]" Then Exit Do
    If a$ = "[SPRITEDEF]" Then
      'increments the current sprite num
      SpriteMax = SpriteMax + 1
      
      'name of the sprite
      Line Input #1, a$
      fval$ = GetPropertyValue(a$)
      Sprites(SpriteMax).SpriteName = fval$
      
      'reset the group number
      Sprites(SpriteMax).GroupMax = 0
      Do
        Line Input #1, a$
        If a$ = "[ENDSPRITEDEF]" Then Exit Do
        If a$ = "-FRAMEGROUP-" Then
          Sprites(SpriteMax).GroupMax = Sprites(SpriteMax).GroupMax + 1
          'Group name
          Line Input #1, a$
          fval$ = GetPropertyValue(a$)
          Sprites(SpriteMax).SpriteFrameGroups(Sprites(SpriteMax).GroupMax).SpriteGroupName = fval$
          'group Repeats
          Line Input #1, a$
          fval$ = GetPropertyValue(a$)
          If fval$ = "True" Then
            YesNo = True
          Else
            YesNo = False
          End If
          Sprites(SpriteMax).SpriteFrameGroups(Sprites(SpriteMax).GroupMax).GroupRepeats = YesNo
          FrameMax = 0
          Do
            Line Input #1, a$
            If a$ = "-ENDFRAMEGROUP-" Then Exit Do
            If a$ = "-FRAME-" Then
              FrameMax = FrameMax + 1
              Sprites(SpriteMax).SpriteFrameGroups(Sprites(SpriteMax).GroupMax).FrameMax = FrameMax
              'Frame name
              Line Input #1, a$
              fval$ = GetPropertyValue(a$)
              Sprites(SpriteMax).SpriteFrameGroups(Sprites(SpriteMax).GroupMax).SpriteFrames(FrameMax).FrameName = fval$
              
              'Frame duration
              Line Input #1, a$
              fval$ = GetPropertyValue(a$)
              Sprites(SpriteMax).SpriteFrameGroups(Sprites(SpriteMax).GroupMax).SpriteFrames(FrameMax).Duration = Val(fval$)
              
              'Frame picture name
              Line Input #1, a$
              fval$ = GetPropertyValue(a$)
              Sprites(SpriteMax).SpriteFrameGroups(Sprites(SpriteMax).GroupMax).SpriteFrames(FrameMax).picname = fval$
            End If
          Loop
        End If
      Loop
    End If
  Loop
Close #1
Exit Sub
ERR2:
Close #1
SpriteMax = 0
End Sub
Sub updateSpritelist()
currindex = Form1.List1.ListIndex
Form1.List1.Clear
Form1.List1.AddItem "[NewSprite]"
For i = 1 To SpriteMax
  Form1.List1.AddItem Sprites(i).SpriteName
Next i
Form1.List1.ListIndex = currindex
Form1.Label1.Caption = Form1.List1.List(Form1.List1.ListIndex)
End Sub
Sub UpdateSpriteProperties()
snum = Form1.List1.ListIndex
If snum > 0 Then
  Form1.Text1.Text = Sprites(snum).SpriteName
Else
  Form1.Text1.Text = ""
End If
Form1.Label1.Caption = Form1.List1.List(Form1.List1.ListIndex)
End Sub

Sub UpdateGroupProperties()
snum = Form1.List1.ListIndex
gnum = Form1.List2.ListIndex

If snum > 0 Then
  Form1.Text2.Text = Sprites(snum).SpriteFrameGroups(gnum).SpriteGroupName
  If Sprites(snum).SpriteFrameGroups(gnum).GroupRepeats = True Then
    Form1.Check1.Value = 1
  Else
    Form1.Check1.Value = 0
  End If

Else
  
  Form1.Text2.Text = ""
  Form1.Check1.Value = 0
End If

End Sub

Sub UpdateGroupList()
currindex = Form1.List2.ListIndex
Form1.List2.Clear
Form1.List2.AddItem "[NewGroup]"
snum = Form1.List1.ListIndex
For i = 1 To Sprites(snum).GroupMax
  Form1.List2.AddItem Sprites(snum).SpriteFrameGroups(i).SpriteGroupName
Next i
Form1.List2.ListIndex = currindex
End Sub

Sub UpdateFrameList()
currindex = Form1.List3.ListIndex
Form1.List3.Clear
Form1.List3.AddItem "[NewFrame]"
snum = Form1.List1.ListIndex
gnum = Form1.List2.ListIndex
For i = 1 To Sprites(snum).SpriteFrameGroups(gnum).FrameMax
  Form1.List3.AddItem Sprites(snum).SpriteFrameGroups(gnum).SpriteFrames(i).FrameName
Next i
Form1.List3.ListIndex = currindex
End Sub

Sub UpdateFrameProperties()
snum = Form1.List1.ListIndex
gnum = Form1.List2.ListIndex
fnum = Form1.List3.ListIndex
If snum > 0 Then
  Form1.Text4.Text = Sprites(snum).SpriteFrameGroups(gnum).SpriteFrames(fnum).Duration
  For i = 0 To Form1.List4.ListCount - 1
    If Sprites(snum).SpriteFrameGroups(gnum).SpriteFrames(fnum).picname = Form1.List4.List(i) Then
      Form1.List4.ListIndex = i
      Exit For
    End If
  Next i
  Form1.Text3.Text = Sprites(snum).SpriteFrameGroups(gnum).SpriteFrames(fnum).FrameName
Else
  Form1.Text3.Text = ""
End If

End Sub
Sub updateSpritenamelist()
On Error Resume Next
Form1.List4.Clear
For i = 1 To PicMax
  Form1.List4.AddItem Picz(i).picname
Next i
For i = 0 To PicMax - 1
  If Form1.List4.List(i) = Sprites(Form1.List5.ListIndex).SpriteFrameGroups(Form1.List2.ListIndex).SpriteFrames(Form1.List3.ListIndex).picname Then
    Form1.List4.ListIndex = i
    Exit For
  End If
Next i
End Sub
Sub LoadGraphicLibs()
On Error GoTo err
LibMax = 0
Open "GraphicLibs.Dat" For Input As #1
Line Input #1, a$
Do
  Line Input #1, a$
  If a$ = "[ENDOFFILE]" Then Exit Do
  If a$ = "[GRAPHICSLIBRARYDEF]" Then
    LibMax = LibMax + 1
    Line Input #1, a$
    fval$ = GetPropertyValue(a$)
    GraphicLibs(LibMax).LibName = fval$
    Line Input #1, a$
    fval$ = GetPropertyValue(a$)
    GraphicLibs(LibMax).picname = fval$
  End If
Loop
Close #1
Exit Sub
err:
Close #1
Exit Sub
End Sub
Sub UpdatePicList()
CurrIndx = Form1.List5.ListIndex
Form1.List5.Clear
Form1.List5.AddItem "[NewPic]"
For i = 1 To PicMax
  Form1.List5.AddItem Picz(i).picname
Next i
Form1.List5.ListIndex = CurrIndx
End Sub
Sub UpdateLibList()
On Error Resume Next
Form1.List6.Clear
For i = 1 To LibMax
  Form1.List6.AddItem GraphicLibs(i).LibName
Next i
Form1.List6.ListIndex = 0
End Sub
Sub UpdatePicProperties()
snum = Form1.List5.ListIndex
If snum > 0 Then
  Form1.Text5.Text = Picz(snum).picname
  Form1.Text6.Text = Picz(snum).X
  Form1.Text8.Text = Picz(snum).Y
  Form1.Text7.Text = Picz(snum).Width
  Form1.Text9.Text = Picz(snum).Height
  Call UpdateLibs
Else
  Form1.Text5.Text = ""
  Form1.Text6.Text = ""
  Form1.Text7.Text = ""
  Form1.Text8.Text = ""
  Form1.Text9.Text = ""

End If
End Sub
Sub LoadLibPic()
On Error Resume Next
If Form1.List6.ListIndex <> -1 Then Form1.Picture2.Picture = LoadPicture(GraphicLibs(Form1.List6.ListIndex + 1).picname)


hnum = Form1.Picture2.ScaleWidth - Form1.Picture1.ScaleWidth
If hnum < 0 Then hnum = 0
hnum = hnum + 1
Form1.HScroll1.Max = hnum

vnum = Form1.Picture2.ScaleHeight - Form1.Picture1.ScaleHeight
If vnum < 0 Then vnum = 0
vnum = vnum + 1
Form1.VScroll1.Max = vnum
Call redrawpicview
End Sub
Sub redrawpicview()
Form1.Picture2.Cls
Form1.Picture2.Line (Picz(Form1.List5.ListIndex).X, Picz(Form1.List5.ListIndex).Y)-((Picz(Form1.List5.ListIndex).X + Picz(Form1.List5.ListIndex).Width) - 1, Picz(Form1.List5.ListIndex).Y + (Picz(Form1.List5.ListIndex).Height) - 1), RGB(255, 0, 255), B
End Sub
Sub UpdateLibs()
For i = 0 To LibMax - 1
  If Form1.List6.List(i) = Picz(Form1.List5.ListIndex).GraphicsLib Then
    Form1.List6.ListIndex = i
    Exit For
  End If
Next i
End Sub
Sub SaveSprites()
Open SPRITEDEFFILE$ For Output As #1
Print #1, CurrVers$
For i = 1 To SpriteMax
  Print #1, "[SPRITEDEF]"
  Print #1, "SpriteName: " & Sprites(i).SpriteName
  For i2 = 1 To Sprites(i).GroupMax
    Print #1, "-FRAMEGROUP-"
    Print #1, "GroupName: " & Sprites(i).SpriteFrameGroups(i2).SpriteGroupName
    Print #1, "Repeats: " & Sprites(i).SpriteFrameGroups(i2).GroupRepeats
    For i3 = 1 To Sprites(i).SpriteFrameGroups(i2).FrameMax
      Print #1, "-FRAME-"
      Print #1, "FrameName: " & Sprites(i).SpriteFrameGroups(i2).SpriteFrames(i3).FrameName
      Print #1, "Duration: " & Sprites(i).SpriteFrameGroups(i2).SpriteFrames(i3).Duration
      Print #1, "PicName: " & Sprites(i).SpriteFrameGroups(i2).SpriteFrames(i3).picname
      Print #1, "-ENDFRAME-"
    Next i3
    Print #1, "-ENDFRAMEGROUP-"
  Next i2
  Print #1, "[ENDSPRITEDEF]"
Next i
Print #1, "[ENDOFFILE]"
Close #1
End Sub

Sub SavePics()
Open PICDEFFILE$ For Output As #1
Print #1, CurrVers$
For i = 1 To PicMax
  Print #1, "[PICDEF]"
  Print #1, "PicName: " & Picz(i).picname
  Print #1, "GraphicsLib: " & Picz(i).GraphicsLib
  Print #1, "X: " & Picz(i).X
  Print #1, "Y: " & Picz(i).Y
  Print #1, "Width: " & Picz(i).Width
  Print #1, "Height: " & Picz(i).Height
  Print #1, "[ENDPICDEF]"
Next i
Print #1, "[ENDOFFILE]"
Close #1
End Sub
